import pygame
import math
from weapon import Weapon


class Player:
    def __init__(self, x, y):
        self.x = float(x)
        self.y = float(y)

        self.max_health = 100
        self.health = self.max_health
        self.alive = True

        self.angle = 0.0

        self.speed = 0.04
        self.rot_speed = 0.03

        self.weapon = Weapon()

    @property
    def pos(self):
        return self.x, self.y

    # --------------------
    # Damage / Death
    # --------------------
    def take_damage(self, amount):
        if not self.alive:
            return

        self.health -= amount

        if self.health <= 0:
            self.health = 0
            self.die()

    def die(self):
        self.alive = False
        print("PLAYER DIED")
        # ➜ GameLoop zeigt jetzt Death Screen

    # --------------------
    # Update
    # --------------------
    def update(self, keys, world_map):
        if not self.alive:
            return  # kein Input wenn tot

        # Rotation
        if keys[pygame.K_a]:
            self.angle -= self.rot_speed
        if keys[pygame.K_d]:
            self.angle += self.rot_speed
        self.angle %= math.tau

        # Movement vector
        dx = math.cos(self.angle) * self.speed
        dy = math.sin(self.angle) * self.speed

        new_x, new_y = self.x, self.y

        if keys[pygame.K_w]:
            new_x += dx
            new_y += dy
        if keys[pygame.K_s]:
            new_x -= dx
            new_y -= dy

        # Collision
        if not world_map.check_collision(new_x, self.y):
            self.x = new_x
        if not world_map.check_collision(self.x, new_y):
            self.y = new_y

        # Shooting
        if keys[pygame.K_SPACE] and self.weapon.can_fire():
            self.weapon.shoot()
            self.weapon.fired_this_frame = True
        else:
            self.weapon.fired_this_frame = False

